﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="registration.aspx.cs" Inherits="registration" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />

    <!-- Bootstrap CSS -->
    <link href="favicon.png" rel="icon">
    <link href="https://fonts.googleapis.com/css?family=Muli:200,300,400,500,600,700,800,900|Oswald:200,300,400,500,600,700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <link href="assets/css/FMCGstyle.css" rel="stylesheet">
	<link href="assets/css/responsive.css" rel="stylesheet">
    <title>CII NATIONAL FMCG SUMMIT</title>
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
        <header class="header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-3 col-sm-3 col-12 lb text-center">
                    <a href="index.aspx" class="logo_box">
                        <img src="assets/images/logo.png" alt="logo" class="img-fluid">
                    </a>
                </div>
                <div class="col-md-7 col-sm-7 col-12"> 
					<ul class="menu">
						<li><a href="index.aspx" class="nav_actv">Home</a></li>
						<li><a href="index.aspx#speakers">Speakers</a></li>
						<li><a href="index.aspx#agenda">Agenda</a></li>
						<li><a href="index.aspx#sponsor">Partners</a></li>
						<li><a href="retrospective.html">Retrospective</a></li>
						<li><a href="gallery.html">Photo Gallery</a></li>
						<li><a href="index.aspx#contact">Contact</a></li>
						<li><a href="about.html">About CII</a></li>
					</ul>
                </div>
                <div class="col-md-2 col-sm-2 col-12 mm">
					<div class="c_text_right">
				    	<a href="registration.aspx" class="register">Register Now</a>
				    	<span class="mobile_menu">
							<img src="assets/images/menu.svg" alt="mobile menu" class="img-fluid">
						</span>
						<div class="mobile_mnu_bx">
							<ul>
								<li><a href="index.aspx" class="nav_actv">Home</a></li>
								<li><a href="index.aspx#speakers">Speakers</a></li>
								<li><a href="index.aspx#agenda">Agenda</a></li>
								<li><a href="index.aspx#sponsor">Partners</a></li>
								<li><a href="retrospective.html">Retrospective</a></li>
								<li><a href="gallery.html">Photo Gallery</a></li>
								<li><a href="index.aspx#contact">Contact</a></li>
								<li><a href="about.html">About CII</a></li>
							</ul>
						</div>
				    </div>
               		
                </div>
            </div>
        </div>
    </header>
        <div class="banner_section">
            <div class="taj">
                <img src="assets/images/taj.png" alt="" class="img-fluid">
            </div>
            <div class="p1" data-speed="0.01" data-revert="true" style="background-image: url(assets/images/products/bg.png)"></div>
            <div class="p2" data-speed="0.02" style="background-image: url(assets/images/prdcts.png)"></div>
            <div class="groth">
                <img src="assets/images/growth.png" alt="" class="img-fluid">
            </div>
        </div>
        <div class="main_wrapper">
            <div class="container section_space">
                <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                    <ContentTemplate>
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-12">
                        <h1 class="title_tag_1">Registration Form</h1>
                    </div>
                    <div class="col-md-12 col-sm-12 col-12 text-center">
                        <asp:Literal ID="litMsg" runat="server"></asp:Literal>
                    </div>
                    <div class="col-md-12 col-sm-12 col-12">
                        <div class="row">
                            <div class="col-md-12 col-sm-12 col-12">
                                <div class="table-responsive" >
                                    <table class="custom_table" border="0" cellpadding="0" cellspacing="0">
                                        <tr class="table_hdr">
                                            <td>Category</td>
                                            <td>Registration Fee</td>
                                        </tr>
                                        <tr class="tb-1">
                                            <td>
                                                Team A (1-5 Delegates)</td>
                                            <td>
                                                INR 2000/- per person</td>
                                        </tr>
                                         <tr class="tb-1">
                                            <td>
                                                Team B (5-10 Delegates)</td>
                                            <td>
                                                INR 1500/- per person</td>
                                        </tr>
                                        <tr class="tb-1">
                                            <td>
                                                Team C (10 or more Delegates)</td>
                                            <td>
                                               INR 1000/ per person</td>
                                        </tr>
                                         <tr align="right">
                                        <td colspan="2">*(GST of 18% applicable)</td>
                                    </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-2 col-sm-2 col-12">
                                <asp:DropDownList ID="ddlPerson" runat="server" CssClass="form-control" AppendDataBoundItems="true" AutoPostBack="true" OnSelectedIndexChanged="ddlPerson_SelectedIndexChanged">
                                    <asp:ListItem Value="0">No. of Person</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                            <div class="col-md-10 col-sm-10 col-12">
                                <p class="nrml_txt mt-1">
                                    We are pleased to nominate the following participant(s) for the “CII National FMCG SUMMIT 2019”</p>
                            </div>
                        </div>
                    <div class="col-md-12 col-sm-12 col-12">
                        <div class="table-responsive">
                            <table border="0" cellpadding="0" cellspacing="0" class="custom_table2">
                                <tr class="table_hdr">
                                    <td width="10%" align="center">Sl No.</td>
                                    <td width="20%">Name</td>
                                    <td width="30%">Designation </td>
                                    <td width="20%">Email</td>
                                    <td width="20%">Mobile</td>
                                </tr>
                                <asp:Repeater ID="rpParticipant" runat="server">
                                    <ItemTemplate>
                                        <tr>
                                            <td width="10%" align="center"><%# Eval("sln")%>
                                                 <asp:HiddenField ID="hdfchecked" runat="server" Value='<%# Eval("checkd")%>' />
                                               <%-- <asp:CheckBox ID="rpchkPerson" runat="server" />--%>
                                                </td>
                                            <td width="20%">
                                                <asp:TextBox ID="rptxtName" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="250"></asp:TextBox>
                                                <ajaxToolkit:FilteredTextBoxExtender ID="ftxtexrptxtName" runat="server" FilterMode="ValidChars"  FilterType="Custom, LowercaseLetters,UppercaseLetters" ValidChars="- " TargetControlID="rptxtName" />
                                            </td>
                                            <td width="30%">
                                                <asp:TextBox ID="rptxtDesignation" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="250"></asp:TextBox>
                                                <ajaxToolkit:FilteredTextBoxExtender ID="ftrptxtDesignation" runat="server" FilterMode="ValidChars"  FilterType="Custom, LowercaseLetters,UppercaseLetters" ValidChars="- " TargetControlID="rptxtDesignation" />
                                                </td>
                                            <td width="20%">
                                                <asp:TextBox ID="rptxtEmail" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="250"></asp:TextBox>
                                                <ajaxToolkit:FilteredTextBoxExtender ID="ftrptxtEmail" runat="server" FilterMode="ValidChars"  FilterType="Custom, LowercaseLetters,UppercaseLetters" ValidChars=".@_-" TargetControlID="rptxtEmail" />
                                                </td>
                                            <td width="20%">
                                                <asp:TextBox ID="rptxtMobile" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="10"></asp:TextBox>
                                                <ajaxToolkit:FilteredTextBoxExtender ID="ftrptxtMobile" runat="server"   FilterType="Numbers"  TargetControlID="rptxtMobile" />
                                                </td>
                                        </tr>
                                    </ItemTemplate>
                                </asp:Repeater>
                                </table>
                            <p style="margin-top:-30px;">
                                <b>Total Registration Fee: </b><asp:Label ID="lblTotalRegFee" runat="server" ></asp:Label></p>
                                <table border="0" cellpadding="0" cellspacing="0" class="custom_table2">
                                <tr class="table_hdr">
                                    <td colspan="5" align="left"><strong>Nominated By:</strong></td>
                                </tr>
                                <tr>
                                    <td colspan="5">
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%" class="inner_tble">
                                            <tr>
                                                <td width="15%">First Name</td>
                                                <td width="35%">
                                                    <asp:TextBox ID="txtFirstName" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="250"></asp:TextBox>
                                                    <ajaxToolkit:FilteredTextBoxExtender ID="ftxtextxtFirstName" runat="server" FilterMode="ValidChars"  FilterType="Custom, LowercaseLetters,UppercaseLetters" ValidChars="- " TargetControlID="txtFirstName" />
                                                    </td>
                                                <td width="15%">Last Name</td>
                                                <td width="35%">
                                                    <asp:TextBox ID="txtLastName" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="250"></asp:TextBox>
                                                    <ajaxToolkit:FilteredTextBoxExtender ID="fttxtLastName" runat="server" FilterMode="ValidChars"  FilterType="Custom, LowercaseLetters,UppercaseLetters" ValidChars="- " TargetControlID="txtLastName" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td width="15%">Designation</td>
                                                <td width="35%" colspan="3">
                                                    <asp:TextBox ID="txtDesignation" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="450"></asp:TextBox>
                                                    <ajaxToolkit:FilteredTextBoxExtender ID="fttxtDesignation" runat="server" FilterMode="ValidChars"  FilterType="Custom, LowercaseLetters,UppercaseLetters" ValidChars="- " TargetControlID="txtDesignation" />
                                                    </td>
                                            </tr>
                                            <tr>
                                                <td width="15%">Mobile</td>
                                                <td width="35%">
                                                    <asp:TextBox ID="txtMobile" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="10"></asp:TextBox>
                                                    <ajaxToolkit:FilteredTextBoxExtender ID="fttxtMobile" runat="server"   FilterType="Numbers"  TargetControlID="txtMobile" />
                                                    </td>
                                                <td width="15%">Email</td>
                                                <td width="35%">
                                                    <asp:TextBox ID="txtEmail" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="250"></asp:TextBox>
                                                    <ajaxToolkit:FilteredTextBoxExtender ID="fttxtEmail" runat="server" FilterMode="ValidChars"  FilterType="Custom, LowercaseLetters,UppercaseLetters" ValidChars=".@_-" TargetControlID="txtEmail" />
                                                    </td>
                                            </tr>
                                            <tr>
                                                <td width="15%">Organization</td>
                                                <td width="35%" colspan="3">
                                                     <asp:TextBox ID="txtOrganization" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="450"></asp:TextBox>
                                                    <ajaxToolkit:FilteredTextBoxExtender ID="fttxtOrganization" runat="server" FilterMode="ValidChars"  FilterType="Custom, LowercaseLetters,UppercaseLetters" ValidChars="- " TargetControlID="txtOrganization" />
                                                    </td>

                                            </tr>
                                            <tr>
                                                <td width="15%">GST No</td>
                                                <td width="35%">
                                                    <asp:TextBox ID="txtGst" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="16"></asp:TextBox>
                                                    <ajaxToolkit:FilteredTextBoxExtender ID="fttxtGst" runat="server"   FilterType="Custom,LowercaseLetters,UppercaseLetters,Numbers"  TargetControlID="txtGst" />
                                                    </td>
                                                <td width="15%">Pan No.(For Individual)</td>
                                                <td width="35%">
                                                    <asp:TextBox ID="txtpanNo" runat="server" CssClass="tble_input" AutoCompleteType="Disabled" MaxLength="20"></asp:TextBox>
                                                    <ajaxToolkit:FilteredTextBoxExtender ID="FilteredTextBoxExtender1" runat="server"   FilterType="Custom,LowercaseLetters,UppercaseLetters,Numbers"  TargetControlID="txtGst" />
                                                   </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                            <div class="text-center">
                                <asp:Button ID="btnSumit" runat="server" CssClass="submit_btn2" Text="Submit" OnClick="btnSumit_Click"  OnClientClick="this.disabled = true; this.value = 'Submitting...';" UseSubmitBehavior="false"/>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6 col-12">
                        <div class="table-responsive">
                           <%-- <table class="custom_table" border="0" cellpadding="0" cellspacing="0" align="center">
                                <tbody>
                                    <tr class="table_hdr">
                                        <td colspan="4">REGISTRATION FEE*</td>
                                    </tr>
                                    <tr class="table_hdr">
                                        <td>CATEGORY</td>
                                        <td>REGISTRATION FEE</td>
                                    </tr>
                                    <tr class="tb-1">
                                        <td>CII Member</td>
                                        <td>INR 5,000/- per person</td>
                                    </tr>
                                    <tr class="tb-1">
                                        <td>Non - Member</td>
                                        <td>INR 5,500/- per person</td>
                                    </tr>
                                    <tr class="tb-1">
                                        <td>Book-a-Table (7 persons) - CII Member</td>
                                        <td>INR 24,500/- per table</td>
                                    </tr>
                                    <tr class="tb-1">
                                        <td>Book-a-Table (7 persons) - CII Non-Member</td>
                                        <td>INR 27,300/- per table</td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">*(+ 18% GST applicable)</td>
                                    </tr>
                                </tbody>
                            </table>--%>
                            <a href="assets/downloads/FMCG_2020_Registration_Form.pdf" target="_blank" class="download_form">Download Form <i class="fa fa-download" aria-hidden="true"></i></a>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6 col-12">
                        <div class="table-responsive">
                            <table class="custom_table" border="0" cellpadding="0" cellspacing="0" align="center">
                                <tbody>
                                    <tr class="table_hdr">
                                        <td>PAYMENT DETAILS</td>
                                    </tr>
                                    <tr class="tb-1">
                                        <td><strong>1) Cheque/DD</strong>
                                            <br>
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Cheque/DD to be drawn in favour of ‘Confederation of Indian Industry’
                                        </td>
                                    </tr>
                                    <tr class="tb-1">
                                        <td><strong>2) Bank Transfer </strong>
                                            <br>
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Please email online payment slip post payment
                                        </td>
                                    </tr>
                                    <tr class="tb-1">
                                        <td><strong>3) Banking Details of CII–SNCEL, Kolkata</strong>
                                            <br>
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Bank Name: ICICI Bank Ltd, Salt Lake, Sector I Branch 
                                        <br>
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Account Name: Confederation of Indian Industry
                                        <br>
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Bank Address: AC-4, Sector-I, Salt Lake City, Kolkata 700064  
                                        <br>
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Account No: 030505005683 
                                        <br>
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Branch Code: 6950 
                                        <br>
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MICR Code: 700229013 
                                        <br>
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;IFSC/NEFT Code: ICIC0000305 
                                        <br>
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Swift Code: ICICINBBCTS 
                                        <br>
                                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Swift Address: LOYDGB2LXXX 
                                
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col-md-12 col-sm-12 col-12">
                        <p class="note_txt">NOTE:</p>
                        <ul class="resistration_notes">
                            <li>Early Bird Discount of 15% per delegate is applicable to registrations done till 3 December 2019. However this discount is not applicable for Book-a-table option</li>
                            <li>For Group participation between 3 and 6 persons, there will be a discount of 10% per delegate (on remaining amount after deduction of Early Bird Discount as applicable). This discount is not applicable for the Book-a-table option</li>
                            <li>Pre- Registration is mandatory; however a change in nomination is allowed
                            </li>
                            <li>Payment is to be made before the commencement of the event
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-12 col-sm-12 col-12 mt-3">
                        <p class="note_txt">CCANCELLATION POLICY:</p>
                        <ul class="resistration_notes">
                            <li>No charges applicable for cancellations done before 48 hours from the commencement	of the event.</li>
                            <li>50% of the delegate fee will be charged for cancellations done within 48 Hours from the commencement of the event.</li>
                            <li>In case of a ‘No Show’, the full amount of the applicable Delegate Fee will be charged.</li>
                        </ul>
                    </div>
                </div>
                           </ContentTemplate>
                </asp:UpdatePanel>
            </div>
        </div>
        <div class="map">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3771.4590658939396!2d72.81726711483024!3d19.043543557940712!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3be7c945f2fb1149%3A0xa2ba742a39963b31!2sTaj%20Lands%20End%2C%20Mumbai!5e0!3m2!1sen!2sin!4v1575453365522!5m2!1sen!2sin" width="100%" height="350" frameborder="0" style="border: 0;" allowfullscreen=""></iframe>
        </div>
        <footer id="contact">
    	<div class="form_bx section_space">
            <div class="container">
                <div class="row">
                    <div class="col-md-5 col-sm-5 col-12 mtxtcent">
                        <h2 class="title_tag_1 blue"><span>quick</span><br>Inquiry</h2>
                        <p class="con_txt">For any inquiry fill this form & <br> submit. We will get back to you<br> as soon as possible.</p>
                    </div>
                    <div class="col-md-7 col-sm-7 col-12">
                        <div class="form-group">
                            <input type="text" placeholder="Name" class="input_contact">
                        </div>
                        <div class="form-group">
                            <input type="email" placeholder="Email" class="input_contact">
                        </div>
                        <div class="form-group">
                            <textarea placeholder="Message" class="input_contact" rows="3"></textarea>
                        </div>
                        <div class="text-center"><input type="submit" value="Submit" class="submit_btn"></div>
                    </div>
                </div>
            </div>
        </div>
       <div class="ftr"> 
           <div class="container">
                <div class="row justify-content-center align-items-center">
                    <div class="col-md-6 col-sm-6 col-12">
                        <div class="contact_person">
                            <h5>Rajib Roy |  Director</h5>
                            <h6>Confederation of Indian Industry</h6>
                            <ul>
                                <li><img src="assets/images/phone.png" alt="phone"><a href="tel:09007512777">09007512777</a></li>
                                <li><img src="assets/images/email.png" alt="phone"><a href="mailto:rajib.roy@cii.in">rajib.roy@cii.in</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6 col-12">
                        <p class="footer_txt">© ciifmcgsummit 2019, All rights reserved<br>
                            <a href="http://www.globopex.com/" target="_blank">Made in Globopex</a></p>
                    </div>
                </div>
            </div>
        </div>
    </footer>
        <a href="javascript:" id="return-to-top"><i class="fa fa-angle-up" aria-hidden="true"></i></a>
        <!-- Optional JavaScript -->
        <!-- jQuery first, then Popper.js, then Bootstrap JS -->
        <script src="https://code.jquery.com/jquery-2.2.4.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
        <script src="assets/js/custom.js"></script>
        <script>
            $(document).ready(function () {
                $('#category').on('change', function () {
                    if (this.value == '1') {
                        $("#for_member").show();
                    }
                    else {
                        $("#for_member").hide();
                    }
                });
            });
            $(document).ready(function () {
                $('#category').on('change', function () {
                    if (this.value == '2') {
                        $("#for_Nonmember").show();
                    }
                    else {
                        $("#for_Nonmember").hide();
                    }
                });
            });
        </script>
    </form>
</body>
</html>
